/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Line Convenience Functions
#include <StdAfx.h>
#include "funcheader.h"
#include "section.h"
#include "CConvenienceExports.h"



HRESULT CreateCSection(double length, double thickness, double width,double extrusionHeight,
					   double blendRadius, ISet **dObjectSet1)
{

	START_METHOD("CreateCSection")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *line1 = NULL;
	status = CreateLine(0, 0, 0, length, &line1);
	CHECK_RETURN_STATUS(status)

	ILine *line2 = NULL;
	status = CreateLine(0, length, width, length, &line2);
	CHECK_RETURN_STATUS(status)

	ILine *line3 = NULL;
	status = CreateLine(width, length, width, length-thickness, &line3);
	CHECK_RETURN_STATUS(status)

	ILine *line4 = NULL;
	status = CreateLine(width, length-thickness, thickness, length-thickness, &line4);
	CHECK_RETURN_STATUS(status)

	ILine *line5 = NULL;
	status = CreateLine(thickness, length-thickness, thickness, thickness, &line5);
	CHECK_RETURN_STATUS(status)

	ILine *line6 = NULL;
	status = CreateLine(thickness, thickness, width, thickness, &line6);
	CHECK_RETURN_STATUS(status)

	ILine *line7 = NULL;
	status = CreateLine(width, thickness, width, 0, &line7);
	CHECK_RETURN_STATUS(status)

	ILine *line8 = NULL;
	status = CreateLine(width, 0, 0, 0, &line8);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add all the sides of the rectangle to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line3);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line4);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line5);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line6);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line7);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line8);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)
	*dObjectSet1 = aLineSet1;

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion1 = NULL;
	status = CreateExtrusion(activeSketch, extrusionHeight, 0, 0, 0, 1, "extrusion", &pExtrusion1);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion1");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Update1");
	CHECK_RETURN_STATUS(status)

  IPartOthers *part1 = CAST(IPartOthers, activePart);

	IBlend *pBlend = NULL;
	ISet *pEdge = NULL;

	IDesign *pDesign = NULL;

	if(blendRadius > 0) {
		status = activePart->GetDesign(&pDesign);
		CHECK_RETURN_STATUS(status)

		status = pDesign->GetEdges(&pEdge);
		CHECK_RETURN_STATUS(status)

		status = ConstantRadiusBlending(pEdge, FALSE, FALSE, FALSE, FALSE, FALSE, blendRadius, "const blend", &pBlend);
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending1");
		CHECK_RETURN_STATUS(status)

		status = activePart->UpdateDesign();
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Update");
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("CreateCSection")
}

HRESULT CreateHSection(double length, double verticalThickness,
					   double horizontalThickness, double width,
					   double extrusionHeight, double blendRadius, ISet **dObjectSet1)
{

	START_METHOD("CreateHSection")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	double k = (length - horizontalThickness)/2.0 ;

	ILine *line1 = NULL;
	status = CreateLine(0, 0, 0, length, &line1);
	CHECK_RETURN_STATUS(status)

	ILine *line2 = NULL;
	status = CreateLine(0, length, verticalThickness, length, &line2);
	CHECK_RETURN_STATUS(status)

	ILine *line3 = NULL;
	status = CreateLine(verticalThickness, length, verticalThickness, k + horizontalThickness, &line3);
	CHECK_RETURN_STATUS(status)

	ILine *line4 = NULL;
	status = CreateLine(verticalThickness, k + horizontalThickness, width - verticalThickness, k + horizontalThickness, &line4);
	CHECK_RETURN_STATUS(status)

	ILine *line5 = NULL;
	status = CreateLine(width-verticalThickness, k+horizontalThickness, width-verticalThickness, length, &line5);
	CHECK_RETURN_STATUS(status)

	ILine *line6 = NULL;
	status = CreateLine(width - verticalThickness, length, width, length, &line6);
	CHECK_RETURN_STATUS(status)

	ILine *line7 = NULL;
	status = CreateLine(width, length, width, 0, &line7);
	CHECK_RETURN_STATUS(status)

	ILine *line8 = NULL;
	status = CreateLine(width, 0, width-verticalThickness, 0, &line8);
	CHECK_RETURN_STATUS(status)

	ILine *line9 = NULL;
	status = CreateLine(width-verticalThickness, 0, width-verticalThickness, k, &line9);
	CHECK_RETURN_STATUS(status)

	ILine *line10 = NULL;
	status = CreateLine(width-verticalThickness, k, verticalThickness, k, &line10);
	CHECK_RETURN_STATUS(status)

	ILine *line11 = NULL;
	status = CreateLine(verticalThickness, k, verticalThickness, 0, &line11);
	CHECK_RETURN_STATUS(status)

	ILine *line12 = NULL;
	status = CreateLine(verticalThickness, 0, 0, 0, &line12);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add all the sides of the rectangle to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line3);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line4);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line5);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line6);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line7);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line8);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line9);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line10);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line11);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line12);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet,aLineSet1));
	CHECK_RETURN_STATUS(status)
	*dObjectSet1 = aLineSet1;

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion1 = NULL;
	status = CreateExtrusion(activeSketch, extrusionHeight, 0, 0,  0, 1, "extrusion", &pExtrusion1);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Update");
	CHECK_RETURN_STATUS(status)

	ISet *pEdge = NULL;
	IDesign *pDesign = NULL;

	IBlend *pBlend = NULL;

	if(blendRadius > 0) {
		status = activePart->GetDesign(&pDesign);
		CHECK_RETURN_STATUS(status)

		status = pDesign->GetEdges(&pEdge);
		CHECK_RETURN_STATUS(status)

		status = ConstantRadiusBlending(pEdge, FALSE, FALSE, FALSE, FALSE, FALSE, blendRadius, "const blend", &pBlend);
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending");
		CHECK_RETURN_STATUS(status)

		status = activePart->UpdateDesign();
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Update");
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("CreateHSection")
}

HRESULT CreateISection(double length, double verticalThickness,
					   double horizontalThickness, double width,
					   double extrusionHeight, double blendRadius, ISet **dObjectSet1)
{

	START_METHOD("CreateISection")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	double k = (width - verticalThickness)/2.0 ;

	ILine *line1 = NULL;
	status = CreateLine(0, 0, 0, horizontalThickness, &line1);
	CHECK_RETURN_STATUS(status)

	ILine *line2 = NULL;
	status = CreateLine(0, horizontalThickness, k, horizontalThickness, &line2);
	CHECK_RETURN_STATUS(status)

	ILine *line3 = NULL;
	status = CreateLine(k, horizontalThickness, k, length+horizontalThickness , &line3);
	CHECK_RETURN_STATUS(status)

	ILine *line4 = NULL;
	status = CreateLine(k, length+horizontalThickness, 0, length+horizontalThickness , &line4);
	CHECK_RETURN_STATUS(status)

	ILine *line5 = NULL;
	status = CreateLine(0, length+horizontalThickness, 0, length+2*horizontalThickness , &line5);
	CHECK_RETURN_STATUS(status)

	ILine *line6 = NULL;
	status = CreateLine(0, length+2*horizontalThickness, width, length+2*horizontalThickness , &line6);
	CHECK_RETURN_STATUS(status)

	ILine *line7 = NULL;
	status = CreateLine(width, length+2*horizontalThickness, width, length+horizontalThickness , &line7);
	CHECK_RETURN_STATUS(status)

	ILine *line8 = NULL;
	status = CreateLine(width, length+horizontalThickness, k+verticalThickness, length+horizontalThickness , &line8);
	CHECK_RETURN_STATUS(status)

	ILine *line9 = NULL;
	status = CreateLine(k+verticalThickness, length+horizontalThickness, k+verticalThickness, horizontalThickness , &line9);
	CHECK_RETURN_STATUS(status)

	ILine *line10 = NULL;
	status = CreateLine(k+verticalThickness, horizontalThickness, width, horizontalThickness , &line10);
	CHECK_RETURN_STATUS(status)

	ILine *line11 = NULL;
	status = CreateLine(width, horizontalThickness, width, 0 , &line11);
	CHECK_RETURN_STATUS(status)

	ILine *line12 = NULL;
	status = CreateLine(width, 0, 0, 0 , &line12);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add all the sides of the rectangle to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line3);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line4);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line5);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line6);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line7);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line8);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line9);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line10);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line11);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line12);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)
	*dObjectSet1 = aLineSet1;

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion = NULL;
	status = CreateExtrusion(activeSketch, extrusionHeight, 0, 0,  0, 1, "extrusion", &pExtrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Update Design");
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	ISet *pEdge = NULL;

	IBlend *pBlend = NULL;

	if(blendRadius > 0) {
		status = activePart->GetDesign(&pDesign);
		CHECK_RETURN_STATUS(status)

		status = pDesign->GetEdges(&pEdge);
		CHECK_RETURN_STATUS(status)

		status = ConstantRadiusBlending(pEdge, FALSE, FALSE, FALSE, FALSE, FALSE, blendRadius, "const blend", &pBlend) ;
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending");
		CHECK_RETURN_STATUS(status)

		status = activePart->UpdateDesign() ;
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Update Design");
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("CreateISection")
}

HRESULT CreateLSection(double length, double thickness, double width, double extrusionHeight,
					   double blendRadius, ISet **dObjectSet1)
{

	START_METHOD("CreateLSection")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *line1 = NULL;
	status = CreateLine(0, 0, 0, length , &line1);
	CHECK_RETURN_STATUS(status)

	ILine *line2 = NULL;
	status = CreateLine(0, length, thickness, length, &line2);
	CHECK_RETURN_STATUS(status)

	ILine *line3 = NULL;
	status = CreateLine(thickness, length, thickness, thickness, &line3);
	CHECK_RETURN_STATUS(status)

	ILine *line4 = NULL;
	status = CreateLine(thickness, thickness, width, thickness, &line4);
	CHECK_RETURN_STATUS(status)

	ILine *line5 = NULL;
	status = CreateLine(width, thickness, width, 0, &line5);
	CHECK_RETURN_STATUS(status)

	ILine *line6 = NULL;
	status = CreateLine(width, 0, 0, 0, &line6);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add all the sides of the rectangle to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line3);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line4);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line5);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line6);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)
	*dObjectSet1 = aLineSet1;

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion = NULL;
	status = CreateExtrusion(activeSketch, extrusionHeight, 0, 0,  0, 1, "extrusion", &pExtrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	ISet *pEdge = NULL;

	IBlend *pBlend = NULL;

	if(blendRadius > 0) {
		status = activePart->GetDesign(&pDesign);
		CHECK_RETURN_STATUS(status)

		status = pDesign->GetEdges(&pEdge);
		CHECK_RETURN_STATUS(status)

		status = ConstantRadiusBlending(pEdge, FALSE, FALSE, FALSE, FALSE, FALSE, blendRadius, "const blend", &pBlend);
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending");
		CHECK_RETURN_STATUS(status)

		status = activePart->UpdateDesign();
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("UpdateDesign");
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("CreateLSection")
}

HRESULT CreateOSection(double length, double thickness, double width, double extrusionHeight,
					   double blendRadius, ISet **dObjectSet1)
{

	START_METHOD("CreateOSection")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ILine *line1 = NULL;
	status = CreateLine(0, 0, 0, length, &line1);
	CHECK_RETURN_STATUS(status)

	ILine *line2 = NULL;
	status = CreateLine(0, length, width, length, &line2);
	CHECK_RETURN_STATUS(status)

	ILine *line3 = NULL;
	status = CreateLine(width, length, width, 0, &line3);
	CHECK_RETURN_STATUS(status)

	ILine *line4 = NULL;
	status = CreateLine(width, 0, 0, 0, &line4);
	CHECK_RETURN_STATUS(status)

	ILine *line5 = NULL;
	status = CreateLine(thickness, thickness, thickness, length-thickness, &line5);
	CHECK_RETURN_STATUS(status)

	ILine *line6 = NULL;
	status = CreateLine(thickness, length-thickness, width-thickness, length-thickness, &line6);
	CHECK_RETURN_STATUS(status)

	ILine *line7 = NULL;
	status = CreateLine(width-thickness, length-thickness, width-thickness, thickness, &line7);
	CHECK_RETURN_STATUS(status)

	ILine *line8 = NULL;
	status = CreateLine(width-thickness, thickness, thickness, thickness, &line8);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add all the sides of the rectangle to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line3);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line4);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line5);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line6);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line7);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line8);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)
	*dObjectSet1 = aLineSet1;

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion = NULL;
	status = CreateExtrusion(activeSketch, extrusionHeight, 0, 0, 0, 1, "extrusion", &pExtrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)
	
	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign = NULL;
	ISet *pEdge = NULL;

	IBlend *pBlend = NULL;

	if(blendRadius > 0) {
		status = activePart->GetDesign(&pDesign);
		CHECK_RETURN_STATUS(status)

		status = pDesign->GetEdges(&pEdge);
		CHECK_RETURN_STATUS(status)

		status = ConstantRadiusBlending(pEdge, FALSE, FALSE, FALSE, FALSE, FALSE, blendRadius, "const blend", &pBlend) ;
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending");
		CHECK_RETURN_STATUS(status)

		status = activePart->UpdateDesign() ;
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending");
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("CreateOSection")
}

HRESULT CreateTSection(double length, double verticalThickness,
					   double horizontalThickness, double width,
					   double extrusionHeight, double blendRadius, ISet **dObjectSet1)
{

	START_METHOD("CreateTSection")

	HRESULT status = NOERROR;

	IApplication *pdApplication = NULL;
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *newPart = NULL;
	status = pdApplication->NewPart(&newPart);
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	double k = (width - verticalThickness)/2.0;

	ILine *line1 = NULL;
	status = CreateLine(k, 0, k, length, &line1);
	CHECK_RETURN_STATUS(status)

	ILine *line2 = NULL;
	status = CreateLine(k, length, 0, length, &line2);
	CHECK_RETURN_STATUS(status)

	ILine *line3 = NULL;
	status = CreateLine(0, length, 0, length+horizontalThickness, &line3);
	CHECK_RETURN_STATUS(status)

	ILine *line4 = NULL;
	status = CreateLine(0, length+horizontalThickness, width, length+horizontalThickness, &line4);
	CHECK_RETURN_STATUS(status)

	ILine *line5 = NULL;
	status = CreateLine(width, length+horizontalThickness, width, length, &line5);
	CHECK_RETURN_STATUS(status)

	ILine *line6 = NULL;
	status = CreateLine(width, length, k+verticalThickness, length, &line6);
	CHECK_RETURN_STATUS(status)

	ILine *line7 = NULL;
	status = CreateLine(k+verticalThickness, length, k+verticalThickness, 0, &line7);
	CHECK_RETURN_STATUS(status)

	ILine *line8 = NULL;
	status = CreateLine(k+verticalThickness, 0, k,0, &line8);
	CHECK_RETURN_STATUS(status)

	// Create a set of lines
	ISet *aLineSet1 = NULL;
	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&aLineSet1);
	CHECK_RETURN_STATUS(status)

	// Add all the sides of the rectangle to the set
	status = aLineSet1->AddMember(line1);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line2);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line3);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line4);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line5);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line6);
	CHECK_RETURN_STATUS(status)

	status = aLineSet1->AddMember(line7);
	CHECK_RETURN_STATUS(status)
	status = aLineSet1->AddMember(line8);
	CHECK_RETURN_STATUS(status)

	// Apply AutoConstrain on the set of lines
	status = activeWorkplane->AutoConstrain(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)
	*dObjectSet1 = aLineSet1;

	// Set the selection to the object set
	status = activeGraphicDoc->SetSelection(CAST(IObjectOrSet, aLineSet1));
	CHECK_RETURN_STATUS(status)

	IExtrusion *pExtrusion = NULL;
	status = CreateExtrusion(activeSketch, extrusionHeight, 0, 0, 0, 1, "extrusion", &pExtrusion);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Extrusion");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)
  
	IDesign *pDesign = NULL;
	ISet *pEdge = NULL;

	IBlend *pBlend = NULL;

	if(blendRadius > 0) {
		status = activePart->GetDesign(&pDesign);
		CHECK_RETURN_STATUS(status)

		status = pDesign->GetEdges(&pEdge);
		CHECK_RETURN_STATUS(status)

		status = ConstantRadiusBlending(pEdge, FALSE, FALSE, FALSE, FALSE, FALSE, blendRadius, "const blend", &pBlend) ;
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("Blending");
		CHECK_RETURN_STATUS(status)

		status = activePart->UpdateDesign();
		CHECK_RETURN_STATUS(status)

		status = CommitToProDESKTOP("UpdateDesign");
		CHECK_RETURN_STATUS(status)
	}

	END_METHOD("CreateTSection")
}
